"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, configuration_recorder_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the configuration recorder. After the configuration recorder is deleted, AWS Config will not record resource configuration changes until you create a new configuration recorder. This action does not delete the configuration information that was previously recorded. You will be able to access the previously recorded information by using the GetResourceConfigHistory action, but you will not be able to access this information in the AWS Config console until you create a new configuration recorder.

    Args:
        configuration_recorder_name(str): The name of the configuration recorder to be deleted. You can retrieve the name of your configuration recorder by using the DescribeConfigurationRecorders action.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.configuration.recorder.init.delete(
                ctx, configuration_recorder_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.configuration.recorder.init.delete configuration_recorder_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_configuration_recorder",
        op_kwargs={"ConfigurationRecorderName": configuration_recorder_name},
    )


async def describe_all(hub, ctx, configuration_recorder_names: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details for the specified configuration recorders. If the configuration recorder is not specified, this action returns the details for all configuration recorders associated with the account.  Currently, you can specify only one configuration recorder per region in your account.

    Args:
        configuration_recorder_names(List, optional): A list of configuration recorder names. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.configuration.recorder.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.configuration.recorder.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_configuration_recorders",
        op_kwargs={"ConfigurationRecorderNames": configuration_recorder_names},
    )


async def put(hub, ctx, configuration_recorder: Dict) -> None:
    r"""
    **Autogenerated function**

    Creates a new configuration recorder to record the selected resource configurations. You can use this action to change the role roleARN or the recordingGroup of an existing recorder. To change the role, call the action on the existing configuration recorder and specify a role.  Currently, you can specify only one configuration recorder per region in your account. If ConfigurationRecorder does not have the recordingGroup parameter specified, the default is to record all supported resource types.

    Args:
        configuration_recorder(Dict): The configuration recorder object that records each configuration change made to the resources.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.configuration.recorder.init.put(
                ctx, configuration_recorder=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.configuration.recorder.init.put configuration_recorder=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_configuration_recorder",
        op_kwargs={"ConfigurationRecorder": configuration_recorder},
    )


async def start(hub, ctx, configuration_recorder_name: str) -> None:
    r"""
    **Autogenerated function**

    Starts recording configurations of the AWS resources you have selected to record in your AWS account. You must have created at least one delivery channel to successfully start the configuration recorder.

    Args:
        configuration_recorder_name(str): The name of the recorder object that records each configuration change made to the resources.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.configuration.recorder.init.start(
                ctx, configuration_recorder_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.configuration.recorder.init.start configuration_recorder_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="start_configuration_recorder",
        op_kwargs={"ConfigurationRecorderName": configuration_recorder_name},
    )


async def stop(hub, ctx, configuration_recorder_name: str) -> None:
    r"""
    **Autogenerated function**

    Stops recording configurations of the AWS resources you have selected to record in your AWS account.

    Args:
        configuration_recorder_name(str): The name of the recorder object that records each configuration change made to the resources.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.configuration.recorder.init.stop(
                ctx, configuration_recorder_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.configuration.recorder.init.stop configuration_recorder_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="stop_configuration_recorder",
        op_kwargs={"ConfigurationRecorderName": configuration_recorder_name},
    )
