"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    configuration_aggregator_name: str,
    update_status: List = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns status information for sources within an aggregator. The status includes information about the last time AWS Config verified authorization between the source account and an aggregator account. In case of a failure, the status contains the related error code or message.

    Args:
        configuration_aggregator_name(str): The name of the configuration aggregator.
        update_status(List, optional): Filters the status type.   Valid value FAILED indicates errors while moving data.   Valid value SUCCEEDED indicates the data was successfully moved.   Valid value OUTDATED indicates the data is not the most recent.  . Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.
        limit(int, optional): The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you specify 0, AWS Config uses the default. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.configuration.aggregator.source_status.describe(
                ctx, configuration_aggregator_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.configuration.aggregator.source_status.describe configuration_aggregator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_configuration_aggregator_sources_status",
        op_kwargs={
            "ConfigurationAggregatorName": configuration_aggregator_name,
            "UpdateStatus": update_status,
            "NextToken": next_token,
            "Limit": limit,
        },
    )
