"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, configuration_aggregator_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.

    Args:
        configuration_aggregator_name(str): The name of the configuration aggregator.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.configuration.aggregator.init.delete(
                ctx, configuration_aggregator_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.configuration.aggregator.init.delete configuration_aggregator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_configuration_aggregator",
        op_kwargs={"ConfigurationAggregatorName": configuration_aggregator_name},
    )


async def describe_all(
    hub,
    ctx,
    configuration_aggregator_names: List = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified, this action returns the details for all the configuration aggregators associated with the account.

    Args:
        configuration_aggregator_names(List, optional): The name of the configuration aggregators. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.
        limit(int, optional): The maximum number of configuration aggregators returned on each page. The default is maximum. If you specify 0, AWS Config uses the default. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.configuration.aggregator.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.configuration.aggregator.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_configuration_aggregators",
        op_kwargs={
            "ConfigurationAggregatorNames": configuration_aggregator_names,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def put(
    hub,
    ctx,
    configuration_aggregator_name: str,
    account_aggregation_sources: List = None,
    organization_aggregation_source: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates and updates the configuration aggregator with the selected source accounts and regions. The source account can be individual account(s) or an organization.  accountIds that are passed will be replaced with existing accounts. If you want to add additional accounts into the aggregator, call DescribeAggregator to get the previous accounts and then append new ones.  AWS Config should be enabled in source accounts and regions you want to aggregate. If your source type is an organization, you must be signed in to the management account or a registered delegated administrator and all the features must be enabled in your organization. If the caller is a management account, AWS Config calls EnableAwsServiceAccess API to enable integration between AWS Config and AWS Organizations. If the caller is a registered delegated administrator, AWS Config calls ListDelegatedAdministrators API to verify whether the caller is a valid delegated administrator. To register a delegated administrator, see Register a Delegated Administrator in the AWS Config developer guide.

    Args:
        configuration_aggregator_name(str): The name of the configuration aggregator.
        account_aggregation_sources(List, optional): A list of AccountAggregationSource object. . Defaults to None.
        organization_aggregation_source(Dict, optional): An OrganizationAggregationSource object. Defaults to None.
        tags(List, optional): An array of tag object. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.configuration.aggregator.init.put(
                ctx, configuration_aggregator_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.configuration.aggregator.init.put configuration_aggregator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_configuration_aggregator",
        op_kwargs={
            "ConfigurationAggregatorName": configuration_aggregator_name,
            "AccountAggregationSources": account_aggregation_sources,
            "OrganizationAggregationSource": organization_aggregation_source,
            "Tags": tags,
        },
    )
