"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deliver(hub, ctx, delivery_channel_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After the delivery has started, AWS Config sends the following notifications using an Amazon SNS topic that you have specified.   Notification of the start of the delivery.   Notification of the completion of the delivery, if the delivery was successfully completed.   Notification of delivery failure, if the delivery failed.

    Args:
        delivery_channel_name(str): The name of the delivery channel through which the snapshot is delivered.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.config.snapshot.deliver(ctx, delivery_channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.config.snapshot.deliver delivery_channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="deliver_config_snapshot",
        op_kwargs={"deliveryChannelName": delivery_channel_name},
    )
