"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, config_rule_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified AWS Config rule and all of its evaluation results. AWS Config sets the state of a rule to DELETING until the deletion is complete. You cannot update a rule while it is in this state. If you make a PutConfigRule or DeleteConfigRule request for the rule, you will receive a ResourceInUseException. You can check the state of a rule by using the DescribeConfigRules request.

    Args:
        config_rule_name(str): The name of the AWS Config rule that you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.config.rule.init.delete(ctx, config_rule_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.config.rule.init.delete config_rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_config_rule",
        op_kwargs={"ConfigRuleName": config_rule_name},
    )


async def describe_all(
    hub, ctx, config_rule_names: List = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns details about your AWS Config rules.

    Args:
        config_rule_names(List, optional): The names of the AWS Config rules for which you want details. If you do not specify any names, AWS Config returns details for all your rules. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.config.rule.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.config.rule.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_config_rules",
        op_kwargs={"ConfigRuleNames": config_rule_names, "NextToken": next_token},
    )


async def put(hub, ctx, config_rule: Dict, tags: List = None) -> None:
    r"""
    **Autogenerated function**

    Adds or updates an AWS Config rule for evaluating whether your AWS resources comply with your desired configurations. You can use this action for custom AWS Config rules and AWS managed Config rules. A custom AWS Config rule is a rule that you develop and maintain. An AWS managed Config rule is a customizable, predefined rule that AWS Config provides. If you are adding a new custom AWS Config rule, you must first create the AWS Lambda function that the rule invokes to evaluate your resources. When you use the PutConfigRule action to add the rule to AWS Config, you must specify the Amazon Resource Name (ARN) that AWS Lambda assigns to the function. Specify the ARN for the SourceIdentifier key. This key is part of the Source object, which is part of the ConfigRule object.  If you are adding an AWS managed Config rule, specify the rule's identifier for the SourceIdentifier key. To reference AWS managed Config rule identifiers, see About AWS Managed Config Rules. For any new rule that you add, specify the ConfigRuleName in the ConfigRule object. Do not specify the ConfigRuleArn or the ConfigRuleId. These values are generated by AWS Config for new rules. If you are updating a rule that you added previously, you can specify the rule by ConfigRuleName, ConfigRuleId, or ConfigRuleArn in the ConfigRule data type that you use in this request. The maximum number of rules that AWS Config supports is 150. For information about requesting a rule limit increase, see AWS Config Limits in the AWS General Reference Guide. For more information about developing and using AWS Config rules, see Evaluating AWS Resource Configurations with AWS Config in the AWS Config Developer Guide.

    Args:
        config_rule(Dict): The rule that you want to add to your account.
        tags(List, optional): An array of tag object. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.config.rule.init.put(ctx, config_rule=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.config.rule.init.put config_rule=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_config_rule",
        op_kwargs={"ConfigRule": config_rule, "Tags": tags},
    )
