"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub, ctx, config_rule_names: List = None, next_token: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns status information for each of your AWS managed Config rules. The status includes information such as the last time AWS Config invoked the rule, the last time AWS Config failed to invoke the rule, and the related error for the last failure.

    Args:
        config_rule_names(List, optional): The name of the AWS managed Config rules for which you want status information. If you do not specify any names, AWS Config returns status information for all AWS managed Config rules that you use. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.
        limit(int, optional): The number of rule evaluation results that you want returned. This parameter is required if the rule limit for your account is more than the default of 150 rules. For information about requesting a rule limit increase, see AWS Config Limits in the AWS General Reference Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.config.rule.evaluation.status.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.config.rule.evaluation.status.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_config_rule_evaluation_status",
        op_kwargs={
            "ConfigRuleNames": config_rule_names,
            "NextToken": next_token,
            "Limit": limit,
        },
    )
