"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "resource_type"


async def get(hub, ctx, resource_types: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or more resource types to get these numbers for each resource type. The maximum number returned is 100.

    Args:
        resource_types(List, optional): Specify one or more resource types to get the number of resources that are compliant and the number that are noncompliant for each resource type. For this request, you can specify an AWS resource type such as AWS::EC2::Instance. You can specify that the resource type is an AWS account by specifying AWS::::Account. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.compliance.summary_by.resource_type_.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.compliance.summary_by.resource_type.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="get_compliance_summary_by_resource_type",
        op_kwargs={"ResourceTypes": resource_types},
    )
