"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns the number of AWS Config rules that are compliant and noncompliant, up to a maximum of 25 for each.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.compliance.summary_by.config_rule.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.compliance.summary_by.config_rule.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="get_compliance_summary_by_config_rule",
        op_kwargs={},
    )
