"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    resource_type: str,
    resource_id: str,
    compliance_types: List = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the evaluation results for the specified AWS resource. The results indicate which AWS Config rules were used to evaluate the resource, when each rule was last used, and whether the resource complies with each rule.

    Args:
        resource_type(str): The type of the AWS resource for which you want compliance information.
        resource_id(str): The ID of the AWS resource for which you want compliance information.
        compliance_types(List, optional): Filters the results by compliance. The allowed values are COMPLIANT, NON_COMPLIANT, and NOT_APPLICABLE. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.compliance.detail_by.resource.get(
                ctx, resource_type=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.compliance.detail_by.resource.get resource_type=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="get_compliance_details_by_resource",
        op_kwargs={
            "ResourceType": resource_type,
            "ResourceId": resource_id,
            "ComplianceTypes": compliance_types,
            "NextToken": next_token,
        },
    )
