"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    config_rule_names: List = None,
    compliance_types: List = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Indicates whether the specified AWS Config rules are compliant. If a rule is noncompliant, this action returns the number of AWS resources that do not comply with the rule. A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these resources do not comply. If AWS Config has no current evaluation results for the rule, it returns INSUFFICIENT_DATA. This result might indicate one of the following conditions:   AWS Config has never invoked an evaluation for the rule. To check whether it has, use the DescribeConfigRuleEvaluationStatus action to get the LastSuccessfulInvocationTime and LastFailedInvocationTime.   The rule's AWS Lambda function is failing to send evaluation results to AWS Config. Verify that the role you assigned to your configuration recorder includes the config:PutEvaluations permission. If the rule is a custom rule, verify that the AWS Lambda execution role includes the config:PutEvaluations permission.   The rule's AWS Lambda function has returned NOT_APPLICABLE for all evaluation results. This can occur if the resources were deleted or removed from the rule's scope.

    Args:
        config_rule_names(List, optional): Specify one or more AWS Config rule names to filter the results by rule. Defaults to None.
        compliance_types(List, optional): Filters the results by compliance. The allowed values are COMPLIANT and NON_COMPLIANT. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.compliance.by.config_rule.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.compliance.by.config_rule.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_compliance_by_config_rule",
        op_kwargs={
            "ConfigRuleNames": config_rule_names,
            "ComplianceTypes": compliance_types,
            "NextToken": next_token,
        },
    )
