"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, authorized_account_id: str, authorized_aws_region: str
) -> None:
    r"""
    **Autogenerated function**

    Deletes the authorization granted to the specified configuration aggregator account in a specified region.

    Args:
        authorized_account_id(str): The 12-digit account ID of the account authorized to aggregate data.
        authorized_aws_region(str): The region authorized to collect aggregated data.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.aggregation_authorization.delete(
                ctx, authorized_account_id=value, authorized_aws_region=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.aggregation_authorization.delete authorized_account_id=value, authorized_aws_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_aggregation_authorization",
        op_kwargs={
            "AuthorizedAccountId": authorized_account_id,
            "AuthorizedAwsRegion": authorized_aws_region,
        },
    )


async def describe_all(hub, ctx, limit: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of authorizations granted to various aggregator accounts and regions.

    Args:
        limit(int, optional): The maximum number of AggregationAuthorizations returned on each page. The default is maximum. If you specify 0, AWS Config uses the default. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.aggregation_authorization.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.aggregation_authorization.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_aggregation_authorizations",
        op_kwargs={"Limit": limit, "NextToken": next_token},
    )


async def put(
    hub, ctx, authorized_account_id: str, authorized_aws_region: str, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Authorizes the aggregator account and region to collect data from the source account and region.

    Args:
        authorized_account_id(str): The 12-digit account ID of the account authorized to aggregate data.
        authorized_aws_region(str): The region authorized to collect aggregated data.
        tags(List, optional): An array of tag object. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.aggregation_authorization.put(
                ctx, authorized_account_id=value, authorized_aws_region=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.aggregation_authorization.put authorized_account_id=value, authorized_aws_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_aggregation_authorization",
        op_kwargs={
            "AuthorizedAccountId": authorized_account_id,
            "AuthorizedAwsRegion": authorized_aws_region,
            "Tags": tags,
        },
    )
