"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, configuration_aggregator_name: str, resource_identifier: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Returns configuration item that is aggregated for your specific resource in a specific source account and region.

    Args:
        configuration_aggregator_name(str): The name of the configuration aggregator.
        resource_identifier(Dict): An object that identifies aggregate resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.aggregate.resource_config.get(
                ctx, configuration_aggregator_name=value, resource_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.aggregate.resource_config.get configuration_aggregator_name=value, resource_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="get_aggregate_resource_config",
        op_kwargs={
            "ConfigurationAggregatorName": configuration_aggregator_name,
            "ResourceIdentifier": resource_identifier,
        },
    )


async def select(
    hub,
    ctx,
    expression: str,
    configuration_aggregator_name: str,
    limit: int = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of AWS resources across multiple accounts and regions, performs the corresponding search, and returns resource configurations matching the properties. For more information about query components, see the  Query Components  section in the AWS Config Developer Guide.

    Args:
        expression(str): The SQL query SELECT command. .
        configuration_aggregator_name(str): The name of the configuration aggregator.
        limit(int, optional): The maximum number of query results returned on each page. . Defaults to None.
        max_results(int, optional): The maximum number of query results returned on each page. AWS Config also allows the Limit request parameter. Defaults to None.
        next_token(str, optional): The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.aggregate.resource_config.select(
                ctx, expression=value, configuration_aggregator_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.aggregate.resource_config.select expression=value, configuration_aggregator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="select_aggregate_resource_config",
        op_kwargs={
            "Expression": expression,
            "ConfigurationAggregatorName": configuration_aggregator_name,
            "Limit": limit,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
