"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    configuration_aggregator_name: str,
    resource_type: str,
    filters: Dict = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom resource name, source account, and source region. You can narrow the results to include only resources that have specific resource IDs, or a resource name, or source account ID, or source region. For example, if the input consists of accountID 12345678910 and the region is us-east-1 for resource type AWS::EC2::Instance then the API returns all the EC2 instance identifiers of accountID 12345678910 and region us-east-1.

    Args:
        configuration_aggregator_name(str): The name of the configuration aggregator. .
        resource_type(str): The type of resources that you want AWS Config to list in the response.
        filters(Dict, optional): Filters the results based on the ResourceFilters object. Defaults to None.
        limit(int, optional): The maximum number of resource identifiers returned on each page. You cannot specify a number greater than 100. If you specify 0, AWS Config uses the default. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.aggregate.discovered_resource.init.list_all(
                ctx, configuration_aggregator_name=value, resource_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.aggregate.discovered_resource.init.list_all configuration_aggregator_name=value, resource_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="list_aggregate_discovered_resources",
        op_kwargs={
            "ConfigurationAggregatorName": configuration_aggregator_name,
            "ResourceType": resource_type,
            "Filters": filters,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
