"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    configuration_aggregator_name: str,
    filters: Dict = None,
    group_by_key: str = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the resource counts across accounts and regions that are present in your AWS Config aggregator. You can request the resource counts by providing filters and GroupByKey. For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.

    Args:
        configuration_aggregator_name(str): The name of the configuration aggregator.
        filters(Dict, optional): Filters the results based on the ResourceCountFilters object. Defaults to None.
        group_by_key(str, optional): The key to group the resource counts. Defaults to None.
        limit(int, optional): The maximum number of GroupedResourceCount objects returned on each page. The default is 1000. You cannot specify a number greater than 1000. If you specify 0, AWS Config uses the default. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.aggregate.discovered_resource.count.get_all(
                ctx, configuration_aggregator_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.aggregate.discovered_resource.count.get_all configuration_aggregator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="get_aggregate_discovered_resource_counts",
        op_kwargs={
            "ConfigurationAggregatorName": configuration_aggregator_name,
            "Filters": filters,
            "GroupByKey": group_by_key,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
