"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    configuration_aggregator_name: str,
    filters: Dict = None,
    group_by_key: str = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the count of compliant and noncompliant conformance packs across all AWS Accounts and AWS Regions in an aggregator. You can filter based on AWS Account ID or AWS Region.  The results can return an empty result page, but if you have a nextToken, the results are displayed on the next page.

    Args:
        configuration_aggregator_name(str): The name of the configuration aggregator.
        filters(Dict, optional): Filters the results based on the AggregateConformancePackComplianceSummaryFilters object. Defaults to None.
        group_by_key(str, optional): Groups the result based on AWS Account ID or AWS Region. Defaults to None.
        limit(int, optional): The maximum number of results returned on each page. The default is maximum. If you specify 0, AWS Config uses the default. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.aggregate.conformance_pack_compliance_summary.get(
                ctx, configuration_aggregator_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.aggregate.conformance_pack_compliance_summary.get configuration_aggregator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="get_aggregate_conformance_pack_compliance_summary",
        op_kwargs={
            "ConfigurationAggregatorName": configuration_aggregator_name,
            "Filters": filters,
            "GroupByKey": group_by_key,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
