"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    configuration_aggregator_name: str,
    config_rule_name: str,
    account_id: str,
    aws_region: str,
    compliance_type: str = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the evaluation results for the specified AWS Config rule for a specific resource in a rule. The results indicate which AWS resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies with the rule.   The results can return an empty result page. But if you have a nextToken, the results are displayed on the next page.

    Args:
        configuration_aggregator_name(str): The name of the configuration aggregator.
        config_rule_name(str): The name of the AWS Config rule for which you want compliance information.
        account_id(str): The 12-digit account ID of the source account.
        aws_region(str): The source region from where the data is aggregated.
        compliance_type(str, optional): The resource compliance status.  For the GetAggregateComplianceDetailsByConfigRuleRequest data type, AWS Config supports only the COMPLIANT and NON_COMPLIANT. AWS Config does not support the NOT_APPLICABLE and INSUFFICIENT_DATA values. . Defaults to None.
        limit(int, optional): The maximum number of evaluation results returned on each page. The default is 50. You cannot specify a number greater than 100. If you specify 0, AWS Config uses the default. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.aggregate.compliance.detail_by_config_rule.get(
                ctx,
                configuration_aggregator_name=value,
                config_rule_name=value,
                account_id=value,
                aws_region=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.aggregate.compliance.detail_by_config_rule.get configuration_aggregator_name=value, config_rule_name=value, account_id=value, aws_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="get_aggregate_compliance_details_by_config_rule",
        op_kwargs={
            "ConfigurationAggregatorName": configuration_aggregator_name,
            "ConfigRuleName": config_rule_name,
            "AccountId": account_id,
            "AwsRegion": aws_region,
            "ComplianceType": compliance_type,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
