"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    configuration_aggregator_name: str,
    filters: Dict = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the conformance packs and their associated compliance status with the count of compliant and noncompliant AWS Config rules within each conformance pack. Also returns the total rule count which includes compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.  The results can return an empty result page, but if you have a nextToken, the results are displayed on the next page.

    Args:
        configuration_aggregator_name(str): The name of the configuration aggregator.
        filters(Dict, optional): Filters the result by AggregateConformancePackComplianceFilters object. Defaults to None.
        limit(int, optional): The maximum number of conformance packs compliance details returned on each page. The default is maximum. If you specify 0, AWS Config uses the default. . Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.aggregate.compliance.by.conformance_pack.describe_all(
                ctx, configuration_aggregator_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.aggregate.compliance.by.conformance_pack.describe_all configuration_aggregator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_aggregate_compliance_by_conformance_packs",
        op_kwargs={
            "ConfigurationAggregatorName": configuration_aggregator_name,
            "Filters": filters,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
