"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    configuration_aggregator_name: str,
    filters: Dict = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant rules.   The results can return an empty result page, but if you have a nextToken, the results are displayed on the next page.

    Args:
        configuration_aggregator_name(str): The name of the configuration aggregator.
        filters(Dict, optional): Filters the results by ConfigRuleComplianceFilters object. . Defaults to None.
        limit(int, optional): The maximum number of evaluation results returned on each page. The default is maximum. If you specify 0, AWS Config uses the default. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.aggregate.compliance.by.config_rule.describe_all(
                ctx, configuration_aggregator_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.aggregate.compliance.by.config_rule.describe_all configuration_aggregator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_aggregate_compliance_by_config_rules",
        op_kwargs={
            "ConfigurationAggregatorName": configuration_aggregator_name,
            "Filters": filters,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
