"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub, ctx, account_ids: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the optimization findings for an account. It returns the number of:   Amazon EC2 instances in an account that are Underprovisioned, Overprovisioned, or Optimized.   Auto Scaling groups in an account that are NotOptimized, or Optimized.   Amazon EBS volumes in an account that are NotOptimized, or Optimized.   Lambda functions in an account that are NotOptimized, or Optimized.

    Args:
        account_ids(List, optional): The ID of the AWS account for which to return recommendation summaries. If your account is the management account of an organization, use this parameter to specify the member account for which you want to return recommendation summaries. Only one account ID can be specified per request. Defaults to None.
        next_token(str, optional): The token to advance to the next page of recommendation summaries. Defaults to None.
        max_results(int, optional): The maximum number of recommendation summaries to return with a single request. To retrieve the remaining results, make another request with the returned NextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.compute_optimizer.recommendation.summary.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.compute_optimizer.recommendation.summary.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="compute-optimizer",
        operation="get_recommendation_summaries",
        op_kwargs={
            "accountIds": account_ids,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
