"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    job_ids: List = None,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes recommendation export jobs created in the last seven days. Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions to request an export of your recommendations. Then use the DescribeRecommendationExportJobs action to view your export jobs.

    Args:
        job_ids(List, optional): The identification numbers of the export jobs to return. An export job ID is returned when you create an export using the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions. All export jobs created in the last seven days are returned if this parameter is omitted. Defaults to None.
        filters(List, optional): An array of objects that describe a filter to return a more specific list of export jobs. Defaults to None.
        next_token(str, optional): The token to advance to the next page of export jobs. Defaults to None.
        max_results(int, optional): The maximum number of export jobs to return with a single request. To retrieve the remaining results, make another request with the returned NextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.compute_optimizer.recommendation.export_job.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.compute_optimizer.recommendation.export_job.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="compute-optimizer",
        operation="describe_recommendation_export_jobs",
        op_kwargs={
            "jobIds": job_ids,
            "filters": filters,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
