"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns the enrollment (opt in) status of an account to the AWS Compute Optimizer service. If the account is the management account of an organization, this action also confirms the enrollment status of member accounts within the organization.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.compute_optimizer.enrollment_status.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.compute_optimizer.enrollment_status.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="compute-optimizer",
        operation="get_enrollment_status",
        op_kwargs={},
    )


async def update(hub, ctx, status: str, include_member_accounts: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the enrollment (opt in and opt out) status of an account to the AWS Compute Optimizer service. If the account is a management account of an organization, this action can also be used to enroll member accounts within the organization. You must have the appropriate permissions to opt in to Compute Optimizer, to view its recommendations, and to opt out. For more information, see Controlling access with AWS Identity and Access Management in the AWS Compute Optimizer User Guide. When you opt in, Compute Optimizer automatically creates a Service-Linked Role in your account to access its data. For more information, see Using Service-Linked Roles for AWS Compute Optimizer in the AWS Compute Optimizer User Guide.

    Args:
        status(str): The new enrollment status of the account. The following status options are available:    Active - Opts in your account to the Compute Optimizer service. Compute Optimizer begins analyzing the configuration and utilization metrics of your AWS resources after you opt in. For more information, see Metrics analyzed by AWS Compute Optimizer in the AWS Compute Optimizer User Guide.    Inactive - Opts out your account from the Compute Optimizer service. Your account's recommendations and related metrics data will be deleted from Compute Optimizer after you opt out.    The Pending and Failed options cannot be used to update the enrollment status of an account. They are returned in the response of a request to update the enrollment status of an account. .
        include_member_accounts(bool, optional): Indicates whether to enroll member accounts of the organization if the account is the management account of an organization. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.compute_optimizer.enrollment_status.update(ctx, status=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.compute_optimizer.enrollment_status.update status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="compute-optimizer",
        operation="update_enrollment_status",
        op_kwargs={"status": status, "includeMemberAccounts": include_member_accounts},
    )
