"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, instance_arn: str, stat: str, period: int, start_time: str, end_time: str
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the projected utilization metrics of Amazon EC2 instance recommendations.  The Cpu and Memory metrics are the only projected utilization metrics returned when you run this action. Additionally, the Memory metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see Enabling Memory Utilization with the CloudWatch Agent.

    Args:
        instance_arn(str): The Amazon Resource Name (ARN) of the instances for which to return recommendation projected metrics.
        stat(str): The statistic of the projected metrics.
        period(int): The granularity, in seconds, of the projected metrics data points.
        start_time(str): The time stamp of the first projected metrics data point to return.
        end_time(str): The time stamp of the last projected metrics data point to return.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.compute_optimizer.ec2.recommendation_projected_metric.get_all(
                ctx, instance_arn=value, stat=value, period=value, start_time=value, end_time=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.compute_optimizer.ec2.recommendation_projected_metric.get_all instance_arn=value, stat=value, period=value, start_time=value, end_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="compute-optimizer",
        operation="get_ec2_recommendation_projected_metrics",
        op_kwargs={
            "instanceArn": instance_arn,
            "stat": stat,
            "period": period,
            "startTime": start_time,
            "endTime": end_time,
        },
    )
