"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def export(
    hub,
    ctx,
    s3_destination_config: Dict,
    account_ids: List = None,
    filters: List = None,
    fields_to_export: List = None,
    file_format: str = None,
    include_member_accounts: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Exports optimization recommendations for Auto Scaling groups. Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see Exporting Recommendations in the Compute Optimizer User Guide. You can have only one Auto Scaling group export job in progress per AWS Region.

    Args:
        account_ids(List, optional): The IDs of the AWS accounts for which to export Auto Scaling group recommendations. If your account is the management account of an organization, use this parameter to specify the member account for which you want to export recommendations. This parameter cannot be specified together with the include member accounts parameter. The parameters are mutually exclusive. Recommendations for member accounts are not included in the export if this parameter, or the include member accounts parameter, is omitted. You can specify multiple account IDs per request. Defaults to None.
        filters(List, optional): An array of objects that describe a filter to export a more specific set of Auto Scaling group recommendations. Defaults to None.
        fields_to_export(List, optional): The recommendations data to include in the export file. For more information about the fields that can be exported, see Exported files in the Compute Optimizer User Guide. Defaults to None.
        s3_destination_config(Dict): An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for the export job. You must create the destination Amazon S3 bucket for your recommendations export before you create the export job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it has the required permission policy to allow Compute Optimizer to write the export file to it. If you plan to specify an object prefix when you create the export job, you must include the object prefix in the policy that you add to the S3 bucket. For more information, see Amazon S3 Bucket Policy for Compute Optimizer in the Compute Optimizer user guide.
        file_format(str, optional): The format of the export file. The only export file format currently supported is Csv. Defaults to None.
        include_member_accounts(bool, optional): Indicates whether to include recommendations for resources in all member accounts of the organization if your account is the management account of an organization. The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see Compute Optimizer and AWS Organizations trusted access in the AWS Compute Optimizer User Guide. Recommendations for member accounts of the organization are not included in the export file if this parameter is omitted. This parameter cannot be specified together with the account IDs parameter. The parameters are mutually exclusive. Recommendations for member accounts are not included in the export if this parameter, or the account IDs parameter, is omitted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.compute_optimizer.auto_scaling_group_recommendation.export(
                ctx, s3_destination_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.compute_optimizer.auto_scaling_group_recommendation.export s3_destination_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="compute-optimizer",
        operation="export_auto_scaling_group_recommendations",
        op_kwargs={
            "accountIds": account_ids,
            "filters": filters,
            "fieldsToExport": fields_to_export,
            "s3DestinationConfig": s3_destination_config,
            "fileFormat": file_format,
            "includeMemberAccounts": include_member_accounts,
        },
    )


async def get_all(
    hub,
    ctx,
    account_ids: List = None,
    auto_scaling_group_arns: List = None,
    next_token: str = None,
    max_results: int = None,
    filters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns Auto Scaling group recommendations. AWS Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that meet a specific set of requirements. For more information, see the Supported resources and requirements in the AWS Compute Optimizer User Guide.

    Args:
        account_ids(List, optional): The ID of the AWS account for which to return Auto Scaling group recommendations. If your account is the management account of an organization, use this parameter to specify the member account for which you want to return Auto Scaling group recommendations. Only one account ID can be specified per request. Defaults to None.
        auto_scaling_group_arns(List, optional): The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return recommendations. Defaults to None.
        next_token(str, optional): The token to advance to the next page of Auto Scaling group recommendations. Defaults to None.
        max_results(int, optional): The maximum number of Auto Scaling group recommendations to return with a single request. To retrieve the remaining results, make another request with the returned NextToken value. Defaults to None.
        filters(List, optional): An array of objects that describe a filter that returns a more specific list of Auto Scaling group recommendations. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.compute_optimizer.auto_scaling_group_recommendation.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.compute_optimizer.auto_scaling_group_recommendation.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="compute-optimizer",
        operation="get_auto_scaling_group_recommendations",
        op_kwargs={
            "accountIds": account_ids,
            "autoScalingGroupArns": auto_scaling_group_arns,
            "nextToken": next_token,
            "maxResults": max_results,
            "filters": filters,
        },
    )
