"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def detect(hub, ctx, text: str) -> Dict:
    r"""
    **Autogenerated function**

     Inspects the clinical text for protected health information (PHI) entities and returns the entity category, location, and confidence score for each entity. Amazon Comprehend Medical only detects entities in English language texts.

    Args:
        text(str):  A UTF-8 text string containing the clinical content being examined for PHI entities. Each string must contain fewer than 20,000 bytes of characters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehendmedical.phi.init.detect(ctx, text=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehendmedical.phi.init.detect text=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehendmedical",
        operation="detect_phi",
        op_kwargs={"Text": text},
    )
