"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def infer(hub, ctx, text: str) -> Dict:
    r"""
    **Autogenerated function**

    InferICD10CM detects medical conditions as entities listed in a patient record and links those entities to normalized concept identifiers in the ICD-10-CM knowledge base from the Centers for Disease Control. Amazon Comprehend Medical only detects medical entities in English language texts.

    Args:
        text(str): The input text used for analysis. The input for InferICD10CM is a string from 1 to 10000 characters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehendmedical.icd10_cm.init.infer(ctx, text=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehendmedical.icd10_cm.init.infer text=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehendmedical",
        operation="infer_icd10_cm",
        op_kwargs={"Text": text},
    )
