"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the properties associated with an InferICD10CM job. Use this operation to get the status of an inference job.

    Args:
        job_id(str): The identifier that Amazon Comprehend Medical generated for the job. The StartICD10CMInferenceJob operation returns this identifier in its response.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehendmedical.icd10_cm.inference_job.describe(
                ctx, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehendmedical.icd10_cm.inference_job.describe job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehendmedical",
        operation="describe_icd10_cm_inference_job",
        op_kwargs={"JobId": job_id},
    )


async def list_all(
    hub, ctx, filter_: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of InferICD10CM jobs that you have submitted.

    Args:
        filter_(Dict, optional): Filters the jobs that are returned. You can filter jobs based on their names, status, or the date and time that they were submitted. You can only set one filter at a time. Defaults to None.
        next_token(str, optional): Identifies the next page of results to return. Defaults to None.
        max_results(int, optional): The maximum number of results to return in each page. The default is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehendmedical.icd10_cm.inference_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehendmedical.icd10_cm.inference_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehendmedical",
        operation="list_icd10_cm_inference_jobs",
        op_kwargs={
            "Filter": filter_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    input_data_config: Dict,
    output_data_config: Dict,
    data_access_role_arn: str,
    language_code: str,
    job_name: str = None,
    client_request_token: str = None,
    kms_key: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an asynchronous job to detect medical conditions and link them to the ICD-10-CM ontology. Use the DescribeICD10CMInferenceJob operation to track the status of a job.

    Args:
        input_data_config(Dict): Specifies the format and location of the input data for the job.
        output_data_config(Dict): Specifies where to send the output files.
        data_access_role_arn(str): The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend Medical read access to your input data. For more information, see  Role-Based Permissions Required for Asynchronous Operations.
        job_name(str, optional): The identifier of the job. Defaults to None.
        client_request_token(str, optional): A unique identifier for the request. If you don't set the client request token, Amazon Comprehend Medical generates one. Defaults to None.
        kms_key(str, optional): An AWS Key Management Service key to encrypt your output files. If you do not specify a key, the files are written in plain text. Defaults to None.
        language_code(str): The language of the input documents. All documents must be in the same language.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehendmedical.icd10_cm.inference_job.start(
                ctx,
                input_data_config=value,
                output_data_config=value,
                data_access_role_arn=value,
                language_code=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehendmedical.icd10_cm.inference_job.start input_data_config=value, output_data_config=value, data_access_role_arn=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehendmedical",
        operation="start_icd10_cm_inference_job",
        op_kwargs={
            "InputDataConfig": input_data_config,
            "OutputDataConfig": output_data_config,
            "DataAccessRoleArn": data_access_role_arn,
            "JobName": job_name,
            "ClientRequestToken": client_request_token,
            "KMSKey": kms_key,
            "LanguageCode": language_code,
        },
    )


async def stop(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops an InferICD10CM inference job in progress.

    Args:
        job_id(str): The identifier of the job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehendmedical.icd10_cm.inference_job.stop(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehendmedical.icd10_cm.inference_job.stop job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehendmedical",
        operation="stop_icd10_cm_inference_job",
        op_kwargs={"JobId": job_id},
    )
