"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def detect(hub, ctx, text: str) -> Dict:
    r"""
    **Autogenerated function**

    The DetectEntities operation is deprecated. You should use the DetectEntitiesV2 operation instead.  Inspects the clinical text for a variety of medical entities and returns specific information about them such as entity category, location, and confidence score on that information .

    Args:
        text(str):  A UTF-8 text string containing the clinical content being examined for entities. Each string must contain fewer than 20,000 bytes of characters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehendmedical.entity.init.detect(ctx, text=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehendmedical.entity.init.detect text=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehendmedical",
        operation="detect_entities",
        op_kwargs={"Text": text},
    )
