"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def stop(hub, ctx, entity_recognizer_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops an entity recognizer training job while in progress. If the training job state is TRAINING, the job is marked for termination and put into the STOP_REQUESTED state. If the training job completes before it can be stopped, it is put into the TRAINED; otherwise the training job is stopped and putted into the STOPPED state and the service sends back an HTTP 200 response with an empty HTTP body.

    Args:
        entity_recognizer_arn(str): The Amazon Resource Name (ARN) that identifies the entity recognizer currently being trained.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.training.entity_recognizer.stop(
                ctx, entity_recognizer_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.training.entity_recognizer.stop entity_recognizer_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="stop_training_entity_recognizer",
        op_kwargs={"EntityRecognizerArn": entity_recognizer_arn},
    )
