"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def stop(hub, ctx, document_classifier_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a document classifier training job while in progress. If the training job state is TRAINING, the job is marked for termination and put into the STOP_REQUESTED state. If the training job completes before it can be stopped, it is put into the TRAINED; otherwise the training job is stopped and put into the STOPPED state and the service sends back an HTTP 200 response with an empty HTTP body.

    Args:
        document_classifier_arn(str): The Amazon Resource Name (ARN) that identifies the document classifier currently being trained.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.training.document_classifier.stop(
                ctx, document_classifier_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.training.document_classifier.stop document_classifier_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="stop_training_document_classifier",
        op_kwargs={"DocumentClassifierArn": document_classifier_arn},
    )
