"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def detect(hub, ctx, text: str, language_code: str) -> Dict:
    r"""
    **Autogenerated function**

    Inspects text for syntax and the part of speech of words in the document. For more information, how-syntax.

    Args:
        text(str): A UTF-8 string. Each string must contain fewer that 5,000 bytes of UTF encoded characters.
        language_code(str): The language code of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt").

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.syntax.detect(ctx, text=value, language_code=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.syntax.detect text=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="detect_syntax",
        op_kwargs={"Text": text, "LanguageCode": language_code},
    )
