"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the properties associated with a sentiment detection job. Use this operation to get the status of a detection job.

    Args:
        job_id(str): The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.sentiment.detection_job.describe(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.sentiment.detection_job.describe job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="describe_sentiment_detection_job",
        op_kwargs={"JobId": job_id},
    )


async def list_all(
    hub, ctx, filter_: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of sentiment detection jobs that you have submitted.

    Args:
        filter_(Dict, optional): Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time. Defaults to None.
        next_token(str, optional): Identifies the next page of results to return. Defaults to None.
        max_results(int, optional): The maximum number of results to return in each page. The default is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.sentiment.detection_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.sentiment.detection_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="list_sentiment_detection_jobs",
        op_kwargs={
            "Filter": filter_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    input_data_config: Dict,
    output_data_config: Dict,
    data_access_role_arn: str,
    language_code: str,
    job_name: str = None,
    client_request_token: str = None,
    volume_kms_key_id: str = None,
    vpc_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an asynchronous sentiment detection job for a collection of documents. use the operation to track the status of a job.

    Args:
        input_data_config(Dict): Specifies the format and location of the input data for the job.
        output_data_config(Dict): Specifies where to send the output files. .
        data_access_role_arn(str): The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data. For more information, see https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions.
        job_name(str, optional): The identifier of the job. Defaults to None.
        language_code(str): The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.
        client_request_token(str, optional): A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one. Defaults to None.
        volume_kms_key_id(str, optional): ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:   KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"    Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"   . Defaults to None.
        vpc_config(Dict, optional): Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your sentiment detection job. For more information, see Amazon VPC. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.sentiment.detection_job.start(
                ctx,
                input_data_config=value,
                output_data_config=value,
                data_access_role_arn=value,
                language_code=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.sentiment.detection_job.start input_data_config=value, output_data_config=value, data_access_role_arn=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="start_sentiment_detection_job",
        op_kwargs={
            "InputDataConfig": input_data_config,
            "OutputDataConfig": output_data_config,
            "DataAccessRoleArn": data_access_role_arn,
            "JobName": job_name,
            "LanguageCode": language_code,
            "ClientRequestToken": client_request_token,
            "VolumeKmsKeyId": volume_kms_key_id,
            "VpcConfig": vpc_config,
        },
    )


async def stop(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a sentiment detection job in progress. If the job state is IN_PROGRESS the job is marked for termination and put into the STOP_REQUESTED state. If the job completes before it can be stopped, it is put into the COMPLETED state; otherwise the job is be stopped and put into the STOPPED state. If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob operation, the operation returns a 400 Internal Request Exception.  When a job is stopped, any documents already processed are written to the output location.

    Args:
        job_id(str): The identifier of the sentiment detection job to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.sentiment.detection_job.stop(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.sentiment.detection_job.stop job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="stop_sentiment_detection_job",
        op_kwargs={"JobId": job_id},
    )
