"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def contains(hub, ctx, text: str, language_code: str) -> Dict:
    r"""
    **Autogenerated function**

    Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of identified PII entity types such as name, address, bank account number, or phone number.

    Args:
        text(str): Creates a new document classification request to analyze a single document in real-time, returning personally identifiable information (PII) entity labels.
        language_code(str): The language of the input documents.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.pii_entity.init.contains(
                ctx, text=value, language_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.pii_entity.init.contains text=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="contains_pii_entities",
        op_kwargs={"Text": text, "LanguageCode": language_code},
    )


async def detect(hub, ctx, text: str, language_code: str) -> Dict:
    r"""
    **Autogenerated function**

    Inspects the input text for entities that contain personally identifiable information (PII) and returns information about them.

    Args:
        text(str): A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.
        language_code(str): The language of the input documents.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.pii_entity.init.detect(
                ctx, text=value, language_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.pii_entity.init.detect text=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="detect_pii_entities",
        op_kwargs={"Text": text, "LanguageCode": language_code},
    )
