"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the properties associated with a PII entities detection job. For example, you can use this operation to get the job status.

    Args:
        job_id(str): The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.pii_entity.detection_job.describe(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.pii_entity.detection_job.describe job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="describe_pii_entities_detection_job",
        op_kwargs={"JobId": job_id},
    )


async def list_all(
    hub, ctx, filter_: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the PII entity detection jobs that you have submitted.

    Args:
        filter_(Dict, optional): Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time. Defaults to None.
        next_token(str, optional): Identifies the next page of results to return. Defaults to None.
        max_results(int, optional): The maximum number of results to return in each page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.pii_entity.detection_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.pii_entity.detection_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="list_pii_entities_detection_jobs",
        op_kwargs={
            "Filter": filter_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    input_data_config: Dict,
    output_data_config: Dict,
    mode: str,
    data_access_role_arn: str,
    language_code: str,
    redaction_config: Dict = None,
    job_name: str = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an asynchronous PII entity detection job for a collection of documents.

    Args:
        input_data_config(Dict): The input properties for a PII entities detection job.
        output_data_config(Dict): Provides conﬁguration parameters for the output of PII entity detection jobs.
        mode(str): Specifies whether the output provides the locations (offsets) of PII entities or a file in which PII entities are redacted.
        redaction_config(Dict, optional): Provides configuration parameters for PII entity redaction. This parameter is required if you set the Mode parameter to ONLY_REDACTION. In that case, you must provide a RedactionConfig definition that includes the PiiEntityTypes parameter. Defaults to None.
        data_access_role_arn(str): The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data.
        job_name(str, optional): The identifier of the job. Defaults to None.
        language_code(str): The language of the input documents.
        client_request_token(str, optional): A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.pii_entity.detection_job.start(
                ctx,
                input_data_config=value,
                output_data_config=value,
                mode=value,
                data_access_role_arn=value,
                language_code=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.pii_entity.detection_job.start input_data_config=value, output_data_config=value, mode=value, data_access_role_arn=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="start_pii_entities_detection_job",
        op_kwargs={
            "InputDataConfig": input_data_config,
            "OutputDataConfig": output_data_config,
            "Mode": mode,
            "RedactionConfig": redaction_config,
            "DataAccessRoleArn": data_access_role_arn,
            "JobName": job_name,
            "LanguageCode": language_code,
            "ClientRequestToken": client_request_token,
        },
    )


async def stop(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a PII entities detection job in progress.

    Args:
        job_id(str): The identifier of the PII entities detection job to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.pii_entity.detection_job.stop(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.pii_entity.detection_job.stop job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="stop_pii_entities_detection_job",
        op_kwargs={"JobId": job_id},
    )
