"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def detect(hub, ctx, text: str, language_code: str) -> Dict:
    r"""
    **Autogenerated function**

    Detects the key noun phrases found in the text.

    Args:
        text(str): A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.
        language_code(str): The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.key_phrase.init.detect(
                ctx, text=value, language_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.key_phrase.init.detect text=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="detect_key_phrases",
        op_kwargs={"Text": text, "LanguageCode": language_code},
    )
