"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the status and details of an events detection job.

    Args:
        job_id(str): The identifier of the events detection job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.event_detection_job.describe(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.event_detection_job.describe job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="describe_events_detection_job",
        op_kwargs={"JobId": job_id},
    )


async def list_all(
    hub, ctx, filter_: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the events detection jobs that you have submitted.

    Args:
        filter_(Dict, optional): Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time. Defaults to None.
        next_token(str, optional): Identifies the next page of results to return. Defaults to None.
        max_results(int, optional): The maximum number of results to return in each page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.event_detection_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.event_detection_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="list_events_detection_jobs",
        op_kwargs={
            "Filter": filter_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    input_data_config: Dict,
    output_data_config: Dict,
    data_access_role_arn: str,
    language_code: str,
    target_event_types: List,
    job_name: str = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an asynchronous event detection job for a collection of documents.

    Args:
        input_data_config(Dict): Specifies the format and location of the input data for the job.
        output_data_config(Dict): Specifies where to send the output files.
        data_access_role_arn(str): The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data.
        job_name(str, optional): The identifier of the events detection job. Defaults to None.
        language_code(str): The language code of the input documents.
        client_request_token(str, optional): An unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one. Defaults to None.
        target_event_types(List): The types of events to detect in the input documents.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.event_detection_job.start(
                ctx,
                input_data_config=value,
                output_data_config=value,
                data_access_role_arn=value,
                language_code=value,
                target_event_types=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.event_detection_job.start input_data_config=value, output_data_config=value, data_access_role_arn=value, language_code=value, target_event_types=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="start_events_detection_job",
        op_kwargs={
            "InputDataConfig": input_data_config,
            "OutputDataConfig": output_data_config,
            "DataAccessRoleArn": data_access_role_arn,
            "JobName": job_name,
            "LanguageCode": language_code,
            "ClientRequestToken": client_request_token,
            "TargetEventTypes": target_event_types,
        },
    )


async def stop(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops an events detection job in progress.

    Args:
        job_id(str): The identifier of the events detection job to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.event_detection_job.stop(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.event_detection_job.stop job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="stop_events_detection_job",
        op_kwargs={"JobId": job_id},
    )
