"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    recognizer_name: str,
    data_access_role_arn: str,
    input_data_config: Dict,
    language_code: str,
    tags: List = None,
    client_request_token: str = None,
    volume_kms_key_id: str = None,
    vpc_config: Dict = None,
    model_kms_key_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an entity recognizer using submitted files. After your CreateEntityRecognizer request is submitted, you can check job status using the API.

    Args:
        recognizer_name(str): The name given to the newly created recognizer. Recognizer names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name must be unique in the account/region.
        data_access_role_arn(str): The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read access to your input data.
        tags(List, optional): Tags to be associated with the entity recognizer being created. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. . Defaults to None.
        input_data_config(Dict): Specifies the format and location of the input data. The S3 bucket containing the input data must be located in the same region as the entity recognizer being created. .
        client_request_token(str, optional):  A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one. Defaults to None.
        language_code(str):  You can specify any of the following languages supported by Amazon Comprehend: English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). All documents must be in the same language.
        volume_kms_key_id(str, optional): ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:   KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"    Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"   . Defaults to None.
        vpc_config(Dict, optional): Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your custom entity recognizer. For more information, see Amazon VPC. . Defaults to None.
        model_kms_key_id(str, optional): ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats   KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"    Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.entity.recognizer.create(
                ctx,
                recognizer_name=value,
                data_access_role_arn=value,
                input_data_config=value,
                language_code=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.entity.recognizer.create recognizer_name=value, data_access_role_arn=value, input_data_config=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="create_entity_recognizer",
        op_kwargs={
            "RecognizerName": recognizer_name,
            "DataAccessRoleArn": data_access_role_arn,
            "Tags": tags,
            "InputDataConfig": input_data_config,
            "ClientRequestToken": client_request_token,
            "LanguageCode": language_code,
            "VolumeKmsKeyId": volume_kms_key_id,
            "VpcConfig": vpc_config,
            "ModelKmsKeyId": model_kms_key_id,
        },
    )


async def delete(hub, ctx, entity_recognizer_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an entity recognizer. Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a ResourceInUseException will be returned. This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a background job. Once removed, the recognizer disappears from your account and is no longer available for use.

    Args:
        entity_recognizer_arn(str): The Amazon Resource Name (ARN) that identifies the entity recognizer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.entity.recognizer.delete(
                ctx, entity_recognizer_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.entity.recognizer.delete entity_recognizer_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="delete_entity_recognizer",
        op_kwargs={"EntityRecognizerArn": entity_recognizer_arn},
    )


async def describe(hub, ctx, entity_recognizer_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer metadata, metrics, and so on.

    Args:
        entity_recognizer_arn(str): The Amazon Resource Name (ARN) that identifies the entity recognizer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.entity.recognizer.describe(
                ctx, entity_recognizer_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.entity.recognizer.describe entity_recognizer_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="describe_entity_recognizer",
        op_kwargs={"EntityRecognizerArn": entity_recognizer_arn},
    )


async def list_all(
    hub, ctx, filter_: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the properties of all entity recognizers that you created, including recognizers currently in training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list. The results of this list are not in any particular order. Please get the list and sort locally if needed.

    Args:
        filter_(Dict, optional): Filters the list of entities returned. You can filter on Status, SubmitTimeBefore, or SubmitTimeAfter. You can only set one filter at a time. Defaults to None.
        next_token(str, optional): Identifies the next page of results to return. Defaults to None.
        max_results(int, optional):  The maximum number of results to return on each page. The default is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.entity.recognizer.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.entity.recognizer.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="list_entity_recognizers",
        op_kwargs={
            "Filter": filter_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
