"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def detect(
    hub, ctx, text: str, language_code: str = None, endpoint_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Inspects text for named entities, and returns information about them. For more information, about named entities, see how-entities.

    Args:
        text(str): A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.
        language_code(str, optional): The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language. If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you specify here. Defaults to None.
        endpoint_arn(str, optional): The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an endpoint if you want to detect entities by using your own custom model instead of the default model that is used by Amazon Comprehend. If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you provide in your request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.entity.init.detect(ctx, text=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.entity.init.detect text=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="detect_entities",
        op_kwargs={
            "Text": text,
            "LanguageCode": language_code,
            "EndpointArn": endpoint_arn,
        },
    )
