"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    endpoint_name: str,
    model_arn: str,
    desired_inference_units: int,
    client_request_token: str = None,
    tags: List = None,
    data_access_role_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a model-specific endpoint for synchronous inference for a previously trained custom model

    Args:
        endpoint_name(str): This is the descriptive suffix that becomes part of the EndpointArn used for all subsequent requests to this resource. .
        model_arn(str): The Amazon Resource Number (ARN) of the model to which the endpoint will be attached.
        desired_inference_units(int):  The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.
        client_request_token(str, optional): An idempotency token provided by the customer. If this token matches a previous endpoint creation request, Amazon Comprehend will not return a ResourceInUseException. . Defaults to None.
        tags(List, optional): Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the sales department. . Defaults to None.
        data_access_role_arn(str, optional): The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that grants Amazon Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.endpoint.create(
                ctx, endpoint_name=value, model_arn=value, desired_inference_units=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.endpoint.create endpoint_name=value, model_arn=value, desired_inference_units=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="create_endpoint",
        op_kwargs={
            "EndpointName": endpoint_name,
            "ModelArn": model_arn,
            "DesiredInferenceUnits": desired_inference_units,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
            "DataAccessRoleArn": data_access_role_arn,
        },
    )


async def delete(hub, ctx, endpoint_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order for the model to be deleted.

    Args:
        endpoint_arn(str): The Amazon Resource Number (ARN) of the endpoint being deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.endpoint.delete(ctx, endpoint_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.endpoint.delete endpoint_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="delete_endpoint",
        op_kwargs={"EndpointArn": endpoint_arn},
    )


async def describe(hub, ctx, endpoint_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint.

    Args:
        endpoint_arn(str): The Amazon Resource Number (ARN) of the endpoint being described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.endpoint.describe(ctx, endpoint_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.endpoint.describe endpoint_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="describe_endpoint",
        op_kwargs={"EndpointArn": endpoint_arn},
    )


async def list_all(
    hub, ctx, filter_: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of all existing endpoints that you've created.

    Args:
        filter_(Dict, optional): Filters the endpoints that are returned. You can filter endpoints on their name, model, status, or the date and time that they were created. You can only set one filter at a time. . Defaults to None.
        next_token(str, optional): Identifies the next page of results to return. Defaults to None.
        max_results(int, optional): The maximum number of results to return in each page. The default is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.endpoint.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.endpoint.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="list_endpoints",
        op_kwargs={
            "Filter": filter_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(hub, ctx, endpoint_arn: str, desired_inference_units: int) -> Dict:
    r"""
    **Autogenerated function**

    Updates information about the specified endpoint.

    Args:
        endpoint_arn(str): The Amazon Resource Number (ARN) of the endpoint being updated.
        desired_inference_units(int):  The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.endpoint.update(
                ctx, endpoint_arn=value, desired_inference_units=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.endpoint.update endpoint_arn=value, desired_inference_units=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="update_endpoint",
        op_kwargs={
            "EndpointArn": endpoint_arn,
            "DesiredInferenceUnits": desired_inference_units,
        },
    )
