"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def classify(hub, ctx, text: str, endpoint_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new document classification request to analyze a single document in real-time, using a previously created and trained custom model and an endpoint.

    Args:
        text(str): The document text to be analyzed.
        endpoint_arn(str): The Amazon Resource Number (ARN) of the endpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.document.init.classify(
                ctx, text=value, endpoint_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.document.init.classify text=value, endpoint_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="classify_document",
        op_kwargs={"Text": text, "EndpointArn": endpoint_arn},
    )
