"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    document_classifier_name: str,
    data_access_role_arn: str,
    input_data_config: Dict,
    language_code: str,
    tags: List = None,
    output_data_config: Dict = None,
    client_request_token: str = None,
    volume_kms_key_id: str = None,
    vpc_config: Dict = None,
    mode: str = None,
    model_kms_key_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a set of training documents that labeled with the categories that you want to use. After the classifier is trained you can use it to categorize a set of labeled documents into the categories. For more information, see how-document-classification.

    Args:
        document_classifier_name(str): The name of the document classifier.
        data_access_role_arn(str): The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read access to your input data.
        tags(List, optional): Tags to be associated with the document classifier being created. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. . Defaults to None.
        input_data_config(Dict): Specifies the format and location of the input data for the job.
        output_data_config(Dict, optional): Enables the addition of output results configuration parameters for custom classifier jobs. Defaults to None.
        client_request_token(str, optional): A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one. Defaults to None.
        language_code(str): The language of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.
        volume_kms_key_id(str, optional): ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:   KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"    Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"   . Defaults to None.
        vpc_config(Dict, optional): Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see Amazon VPC. . Defaults to None.
        mode(str, optional): Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class mode, which identifies one and only one class for each document, or multi-label mode, which identifies one or more labels for each document. In multi-label mode, multiple labels for an individual document are separated by a delimiter. The default delimiter between labels is a pipe (|). Defaults to None.
        model_kms_key_id(str, optional): ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:   KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"    Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.document.classifier.create(
                ctx,
                document_classifier_name=value,
                data_access_role_arn=value,
                input_data_config=value,
                language_code=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.document.classifier.create document_classifier_name=value, data_access_role_arn=value, input_data_config=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="create_document_classifier",
        op_kwargs={
            "DocumentClassifierName": document_classifier_name,
            "DataAccessRoleArn": data_access_role_arn,
            "Tags": tags,
            "InputDataConfig": input_data_config,
            "OutputDataConfig": output_data_config,
            "ClientRequestToken": client_request_token,
            "LanguageCode": language_code,
            "VolumeKmsKeyId": volume_kms_key_id,
            "VpcConfig": vpc_config,
            "Mode": mode,
            "ModelKmsKeyId": model_kms_key_id,
        },
    )


async def delete(hub, ctx, document_classifier_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a previously created document classifier Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a ResourceInUseException will be returned. This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a background job. Once removed, the classifier disappears from your account and is no longer available for use.

    Args:
        document_classifier_arn(str): The Amazon Resource Name (ARN) that identifies the document classifier. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.document.classifier.delete(
                ctx, document_classifier_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.document.classifier.delete document_classifier_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="delete_document_classifier",
        op_kwargs={"DocumentClassifierArn": document_classifier_arn},
    )


async def describe(hub, ctx, document_classifier_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the properties associated with a document classifier.

    Args:
        document_classifier_arn(str): The Amazon Resource Name (ARN) that identifies the document classifier. The operation returns this identifier in its response.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.document.classifier.describe(
                ctx, document_classifier_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.document.classifier.describe document_classifier_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="describe_document_classifier",
        op_kwargs={"DocumentClassifierArn": document_classifier_arn},
    )


async def list_all(
    hub, ctx, filter_: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the document classifiers that you have created.

    Args:
        filter_(Dict, optional): Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time. Defaults to None.
        next_token(str, optional): Identifies the next page of results to return. Defaults to None.
        max_results(int, optional): The maximum number of results to return in each page. The default is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.document.classifier.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.document.classifier.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="list_document_classifiers",
        op_kwargs={
            "Filter": filter_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
