"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the properties associated with a document classification job. Use this operation to get the status of a classification job.

    Args:
        job_id(str): The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.document.classification_job.describe(
                ctx, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.document.classification_job.describe job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="describe_document_classification_job",
        op_kwargs={"JobId": job_id},
    )


async def list_all(
    hub, ctx, filter_: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the documentation classification jobs that you have submitted.

    Args:
        filter_(Dict, optional): Filters the jobs that are returned. You can filter jobs on their names, status, or the date and time that they were submitted. You can only set one filter at a time. Defaults to None.
        next_token(str, optional): Identifies the next page of results to return. Defaults to None.
        max_results(int, optional): The maximum number of results to return in each page. The default is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.document.classification_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.document.classification_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="list_document_classification_jobs",
        op_kwargs={
            "Filter": filter_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    document_classifier_arn: str,
    input_data_config: Dict,
    output_data_config: Dict,
    data_access_role_arn: str,
    job_name: str = None,
    client_request_token: str = None,
    volume_kms_key_id: str = None,
    vpc_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an asynchronous document classification job. Use the operation to track the progress of the job.

    Args:
        job_name(str, optional): The identifier of the job. Defaults to None.
        document_classifier_arn(str): The Amazon Resource Name (ARN) of the document classifier to use to process the job.
        input_data_config(Dict): Specifies the format and location of the input data for the job.
        output_data_config(Dict): Specifies where to send the output files.
        data_access_role_arn(str): The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that grants Amazon Comprehend read access to your input data.
        client_request_token(str, optional): A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one. Defaults to None.
        volume_kms_key_id(str, optional): ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:   KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"    Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"   . Defaults to None.
        vpc_config(Dict, optional): Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your document classification job. For more information, see Amazon VPC. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.document.classification_job.start(
                ctx,
                document_classifier_arn=value,
                input_data_config=value,
                output_data_config=value,
                data_access_role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.document.classification_job.start document_classifier_arn=value, input_data_config=value, output_data_config=value, data_access_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="start_document_classification_job",
        op_kwargs={
            "JobName": job_name,
            "DocumentClassifierArn": document_classifier_arn,
            "InputDataConfig": input_data_config,
            "OutputDataConfig": output_data_config,
            "DataAccessRoleArn": data_access_role_arn,
            "ClientRequestToken": client_request_token,
            "VolumeKmsKeyId": volume_kms_key_id,
            "VpcConfig": vpc_config,
        },
    )
