"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, text_list: List, language_code: str) -> Dict:
    r"""
    **Autogenerated function**

    Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and returns information about them. For more information, see how-syntax.

    Args:
        text_list(List): A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.
        language_code(str): The language of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.detect.syntax.batch(
                ctx, text_list=value, language_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.detect.syntax.batch text_list=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="batch_detect_syntax",
        op_kwargs={"TextList": text_list, "LanguageCode": language_code},
    )
