"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, text_list: List, language_code: str) -> Dict:
    r"""
    **Autogenerated function**

    Detects the key noun phrases found in a batch of documents.

    Args:
        text_list(List): A list containing the text of the input documents. The list can contain a maximum of 25 documents. Each document must contain fewer that 5,000 bytes of UTF-8 encoded characters.
        language_code(str): The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.comprehend.detect.key_phrase.batch(
                ctx, text_list=value, language_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.comprehend.detect.key_phrase.batch text_list=value, language_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="comprehend",
        operation="batch_detect_key_phrases",
        op_kwargs={"TextList": text_list, "LanguageCode": language_code},
    )
