"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub,
    ctx,
    identity_pool_id: str,
    identity_id: str,
    dataset_name: str,
    last_sync_count: int = None,
    next_token: str = None,
    max_results: int = None,
    sync_session_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets paginated records, optionally changed after a particular sync count for a dataset and identity. With Amazon Cognito Sync, each identity has access only to its own data. Thus, the credentials used to make this API call need to have access to the identity data. ListRecords can be called with temporary user credentials provided by Cognito Identity or with developer credentials. You should use Cognito Identity credentials to make this API call.

    Args:
        identity_pool_id(str): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        identity_id(str): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        dataset_name(str): A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        last_sync_count(int, optional): The last server sync count for this record. Defaults to None.
        next_token(str, optional): A pagination token for obtaining the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned. Defaults to None.
        sync_session_token(str, optional): A token containing a session ID, identity ID, and expiration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_sync.record.list_all(
                ctx, identity_pool_id=value, identity_id=value, dataset_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_sync.record.list_all identity_pool_id=value, identity_id=value, dataset_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-sync",
        operation="list_records",
        op_kwargs={
            "IdentityPoolId": identity_pool_id,
            "IdentityId": identity_id,
            "DatasetName": dataset_name,
            "LastSyncCount": last_sync_count,
            "NextToken": next_token,
            "MaxResults": max_results,
            "SyncSessionToken": sync_session_token,
        },
    )


async def update_multiple(
    hub,
    ctx,
    identity_pool_id: str,
    identity_id: str,
    dataset_name: str,
    sync_session_token: str,
    device_id: str = None,
    record_patches: List = None,
    client_context: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Posts updates to records and adds and deletes records for a dataset and user. The sync count in the record patch is your last known sync count for that record. The server will reject an UpdateRecords request with a ResourceConflictException if you try to patch a record with a new value but a stale sync count.For example, if the sync count on the server is 5 for a key called highScore and you try and submit a new highScore with sync count of 4, the request will be rejected. To obtain the current sync count for a record, call ListRecords. On a successful update of the record, the response returns the new sync count for that record. You should present that sync count the next time you try to update that same record. When the record does not exist, specify the sync count as 0. This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials.

    Args:
        identity_pool_id(str): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        identity_id(str): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.
        dataset_name(str): A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).
        device_id(str, optional): The unique ID generated for this device by Cognito. Defaults to None.
        record_patches(List, optional): A list of patch operations. Defaults to None.
        sync_session_token(str): The SyncSessionToken returned by a previous call to ListRecords for this dataset and identity.
        client_context(str, optional): Intended to supply a device ID that will populate the lastModifiedBy field referenced in other methods. The ClientContext field is not yet implemented. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_sync.record.update_multiple(
                ctx,
                identity_pool_id=value,
                identity_id=value,
                dataset_name=value,
                sync_session_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_sync.record.update_multiple identity_pool_id=value, identity_id=value, dataset_name=value, sync_session_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-sync",
        operation="update_records",
        op_kwargs={
            "IdentityPoolId": identity_pool_id,
            "IdentityId": identity_id,
            "DatasetName": dataset_name,
            "DeviceId": device_id,
            "RecordPatches": record_patches,
            "SyncSessionToken": sync_session_token,
            "ClientContext": client_context,
        },
    )
