"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def get(hub, ctx, identity_pool_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the configuration settings of an identity pool.This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.

    Args:
        identity_pool_id(str): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. This is the ID of the pool for which to return a configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_sync.identity.pool.configuration.get(
                ctx, identity_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_sync.identity.pool.configuration.get identity_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-sync",
        operation="get_identity_pool_configuration",
        op_kwargs={"IdentityPoolId": identity_pool_id},
    )


async def set_(
    hub,
    ctx,
    identity_pool_id: str,
    push_sync: Dict = None,
    cognito_streams: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sets the necessary configuration for push sync.This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.

    Args:
        identity_pool_id(str): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. This is the ID of the pool to modify.
        push_sync(Dict, optional): Options to apply to this identity pool for push synchronization. Defaults to None.
        cognito_streams(Dict, optional): Options to apply to this identity pool for Amazon Cognito streams. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_sync.identity.pool.configuration.set(
                ctx, identity_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_sync.identity.pool.configuration.set identity_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-sync",
        operation="set_identity_pool_configuration",
        op_kwargs={
            "IdentityPoolId": identity_pool_id,
            "PushSync": push_sync,
            "CognitoStreams": cognito_streams,
        },
    )
