"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def unsubscribe(
    hub, ctx, identity_pool_id: str, identity_id: str, dataset_name: str, device_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Unsubscribes from receiving notifications when a dataset is modified by another device.This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API with developer credentials.

    Args:
        identity_pool_id(str): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. The ID of the pool to which this identity belongs.
        identity_id(str): Unique ID for this identity.
        dataset_name(str): The name of the dataset from which to unsubcribe.
        device_id(str): The unique ID generated for this device by Cognito.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_sync.from_dataset.unsubscribe(
                ctx, identity_pool_id=value, identity_id=value, dataset_name=value, device_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_sync.from_dataset.unsubscribe identity_pool_id=value, identity_id=value, dataset_name=value, device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-sync",
        operation="unsubscribe_from_dataset",
        op_kwargs={
            "IdentityPoolId": identity_pool_id,
            "IdentityId": identity_id,
            "DatasetName": dataset_name,
            "DeviceId": device_id,
        },
    )
