"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def register(
    hub, ctx, identity_pool_id: str, identity_id: str, platform: str, token: str
) -> Dict:
    r"""
    **Autogenerated function**

    Registers a device to receive push sync notifications.This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API with developer credentials.

    Args:
        identity_pool_id(str): A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. Here, the ID of the pool that the identity belongs to.
        identity_id(str): The unique ID for this identity.
        platform(str): The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX).
        token(str): The push token.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_sync.device.register(
                ctx, identity_pool_id=value, identity_id=value, platform=value, token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_sync.device.register identity_pool_id=value, identity_id=value, platform=value, token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-sync",
        operation="register_device",
        op_kwargs={
            "IdentityPoolId": identity_pool_id,
            "IdentityId": identity_id,
            "Platform": platform,
            "Token": token,
        },
    )
