"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, access_token: str, mfa_options: List) -> Dict:
    r"""
    **Autogenerated function**

     This action is no longer supported. You can use it to configure only SMS MFA. You can't use it to configure TOTP software token MFA. To configure either type of MFA, use SetUserMFAPreference instead.

    Args:
        access_token(str): The access token for the set user settings request.
        mfa_options(List): You can use this parameter only to set an SMS configuration that uses SMS for delivery.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.setting.set(
                ctx, access_token=value, mfa_options=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.setting.set access_token=value, mfa_options=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="set_user_settings",
        op_kwargs={"AccessToken": access_token, "MFAOptions": mfa_options},
    )
