"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def get(hub, ctx, user_pool_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the user pool multi-factor authentication (MFA) configuration.

    Args:
        user_pool_id(str): The user pool ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.pool.mfa_config.get(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.pool.mfa_config.get user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="get_user_pool_mfa_config",
        op_kwargs={"UserPoolId": user_pool_id},
    )


async def set_(
    hub,
    ctx,
    user_pool_id: str,
    sms_mfa_configuration: Dict = None,
    software_token_mfa_configuration: Dict = None,
    mfa_configuration: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Set the user pool multi-factor authentication (MFA) configuration.  This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with Amazon Pinpoint. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in. If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In  sandbox mode , you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see  SMS message settings for Cognito User Pools in the Amazon Cognito Developer Guide.

    Args:
        user_pool_id(str): The user pool ID.
        sms_mfa_configuration(Dict, optional): The SMS text message MFA configuration. Defaults to None.
        software_token_mfa_configuration(Dict, optional): The software token MFA configuration. Defaults to None.
        mfa_configuration(str, optional): The MFA configuration. Users who don't have an MFA factor set up won't be able to sign-in if you set the MfaConfiguration value to ‘ON’. See Adding Multi-Factor Authentication (MFA) to a User Pool to learn more. Valid values include:    OFF MFA will not be used for any users.    ON MFA is required for all users to sign in.    OPTIONAL MFA will be required only for individual users who have an MFA factor enabled.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.pool.mfa_config.set(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.pool.mfa_config.set user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="set_user_pool_mfa_config",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "SmsMfaConfiguration": sms_mfa_configuration,
            "SoftwareTokenMfaConfiguration": software_token_mfa_configuration,
            "MfaConfiguration": mfa_configuration,
        },
    )
