"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    pool_name: str,
    policies: Dict = None,
    lambda_config: Dict = None,
    auto_verified_attributes: List = None,
    alias_attributes: List = None,
    username_attributes: List = None,
    sms_verification_message: str = None,
    email_verification_message: str = None,
    email_verification_subject: str = None,
    verification_message_template: Dict = None,
    sms_authentication_message: str = None,
    mfa_configuration: str = None,
    device_configuration: Dict = None,
    email_configuration: Dict = None,
    sms_configuration: Dict = None,
    user_pool_tags: Dict = None,
    admin_create_user_config: Dict = None,
    schema: List = None,
    user_pool_add_ons: Dict = None,
    username_configuration: Dict = None,
    account_recovery_setting: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon Cognito user pool and sets the password policy for the pool.  This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with Amazon Pinpoint. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in. If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In  sandbox mode , you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see  SMS message settings for Cognito User Pools in the Amazon Cognito Developer Guide.

    Args:
        pool_name(str): A string used to name the user pool.
        policies(Dict, optional): The policies associated with the new user pool. Defaults to None.
        lambda_config(Dict, optional): The Lambda trigger configuration information for the new user pool.  In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you will need to make an extra call to add permission for these event sources to invoke your Lambda function.  For more information on using the Lambda API to add permission, see  AddPermission .  For adding permission using the CLI, see  add-permission . . Defaults to None.
        auto_verified_attributes(List, optional): The attributes to be auto-verified. Possible values: email, phone_number. Defaults to None.
        alias_attributes(List, optional): Attributes supported as an alias for this user pool. Possible values: phone_number, email, or preferred_username. Defaults to None.
        username_attributes(List, optional): Specifies whether email addresses or phone numbers can be specified as usernames when a user signs up. Defaults to None.
        sms_verification_message(str, optional): A string representing the SMS verification message. Defaults to None.
        email_verification_message(str, optional): A string representing the email verification message. EmailVerificationMessage is allowed only if EmailSendingAccount is DEVELOPER. . Defaults to None.
        email_verification_subject(str, optional): A string representing the email verification subject. EmailVerificationSubject is allowed only if EmailSendingAccount is DEVELOPER. . Defaults to None.
        verification_message_template(Dict, optional): The template for the verification message that the user sees when the app requests permission to access the user's information. Defaults to None.
        sms_authentication_message(str, optional): A string representing the SMS authentication message. Defaults to None.
        mfa_configuration(str, optional): Specifies MFA configuration details. Defaults to None.
        device_configuration(Dict, optional): The device configuration. Defaults to None.
        email_configuration(Dict, optional): The email configuration. Defaults to None.
        sms_configuration(Dict, optional): The SMS configuration. Defaults to None.
        user_pool_tags(Dict, optional): The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria. Defaults to None.
        admin_create_user_config(Dict, optional): The configuration for AdminCreateUser requests. Defaults to None.
        schema(List, optional): An array of schema attributes for the new user pool. These attributes can be standard or custom attributes. Defaults to None.
        user_pool_add_ons(Dict, optional): Used to enable advanced security risk detection. Set the key AdvancedSecurityMode to the value "AUDIT". Defaults to None.
        username_configuration(Dict, optional): You can choose to set case sensitivity on the username input for the selected sign-in option. For example, when this is set to False, users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see UsernameConfigurationType. Defaults to None.
        account_recovery_setting(Dict, optional): Use this setting to define which verified available method a user can use to recover their password when they call ForgotPassword. It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.pool.init.create(ctx, pool_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.pool.init.create pool_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="create_user_pool",
        op_kwargs={
            "PoolName": pool_name,
            "Policies": policies,
            "LambdaConfig": lambda_config,
            "AutoVerifiedAttributes": auto_verified_attributes,
            "AliasAttributes": alias_attributes,
            "UsernameAttributes": username_attributes,
            "SmsVerificationMessage": sms_verification_message,
            "EmailVerificationMessage": email_verification_message,
            "EmailVerificationSubject": email_verification_subject,
            "VerificationMessageTemplate": verification_message_template,
            "SmsAuthenticationMessage": sms_authentication_message,
            "MfaConfiguration": mfa_configuration,
            "DeviceConfiguration": device_configuration,
            "EmailConfiguration": email_configuration,
            "SmsConfiguration": sms_configuration,
            "UserPoolTags": user_pool_tags,
            "AdminCreateUserConfig": admin_create_user_config,
            "Schema": schema,
            "UserPoolAddOns": user_pool_add_ons,
            "UsernameConfiguration": username_configuration,
            "AccountRecoverySetting": account_recovery_setting,
        },
    )


async def delete(hub, ctx, user_pool_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified Amazon Cognito user pool.

    Args:
        user_pool_id(str): The user pool ID for the user pool you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.pool.init.delete(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.pool.init.delete user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="delete_user_pool",
        op_kwargs={"UserPoolId": user_pool_id},
    )


async def describe(hub, ctx, user_pool_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the configuration information and metadata of the specified user pool.

    Args:
        user_pool_id(str): The user pool ID for the user pool you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.pool.init.describe(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.pool.init.describe user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="describe_user_pool",
        op_kwargs={"UserPoolId": user_pool_id},
    )


async def list_all(hub, ctx, max_results: int, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the user pools associated with an account.

    Args:
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.
        max_results(int): The maximum number of results you want the request to return when listing the user pools.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.pool.init.list_all(ctx, max_results=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.pool.init.list_all max_results=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="list_user_pools",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub,
    ctx,
    user_pool_id: str,
    policies: Dict = None,
    lambda_config: Dict = None,
    auto_verified_attributes: List = None,
    sms_verification_message: str = None,
    email_verification_message: str = None,
    email_verification_subject: str = None,
    verification_message_template: Dict = None,
    sms_authentication_message: str = None,
    mfa_configuration: str = None,
    device_configuration: Dict = None,
    email_configuration: Dict = None,
    sms_configuration: Dict = None,
    user_pool_tags: Dict = None,
    admin_create_user_config: Dict = None,
    user_pool_add_ons: Dict = None,
    account_recovery_setting: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified user pool with the specified attributes. You can get a list of the current user pool settings using DescribeUserPool. If you don't provide a value for an attribute, it will be set to the default value.  This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with Amazon Pinpoint. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in. If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In  sandbox mode , you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see  SMS message settings for Cognito User Pools in the Amazon Cognito Developer Guide.

    Args:
        user_pool_id(str): The user pool ID for the user pool you want to update.
        policies(Dict, optional): A container with the policies you wish to update in a user pool. Defaults to None.
        lambda_config(Dict, optional): The Lambda configuration information from the request to update the user pool. Defaults to None.
        auto_verified_attributes(List, optional): The attributes that are automatically verified when the Amazon Cognito service makes a request to update user pools. Defaults to None.
        sms_verification_message(str, optional): A container with information about the SMS verification message. Defaults to None.
        email_verification_message(str, optional): The contents of the email verification message. Defaults to None.
        email_verification_subject(str, optional): The subject of the email verification message. Defaults to None.
        verification_message_template(Dict, optional): The template for verification messages. Defaults to None.
        sms_authentication_message(str, optional): The contents of the SMS authentication message. Defaults to None.
        mfa_configuration(str, optional): Can be one of the following values:    OFF - MFA tokens are not required and cannot be specified during user registration.    ON - MFA tokens are required for all user registrations. You can only specify ON when you are initially creating a user pool. You can use the SetUserPoolMfaConfig API operation to turn MFA "ON" for existing user pools.     OPTIONAL - Users have the option when registering to create an MFA token.  . Defaults to None.
        device_configuration(Dict, optional): Device configuration. Defaults to None.
        email_configuration(Dict, optional): Email configuration. Defaults to None.
        sms_configuration(Dict, optional): SMS configuration. Defaults to None.
        user_pool_tags(Dict, optional): The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria. Defaults to None.
        admin_create_user_config(Dict, optional): The configuration for AdminCreateUser requests. Defaults to None.
        user_pool_add_ons(Dict, optional): Used to enable advanced security risk detection. Set the key AdvancedSecurityMode to the value "AUDIT". Defaults to None.
        account_recovery_setting(Dict, optional): Use this setting to define which verified available method a user can use to recover their password when they call ForgotPassword. It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.pool.init.update(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.pool.init.update user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="update_user_pool",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "Policies": policies,
            "LambdaConfig": lambda_config,
            "AutoVerifiedAttributes": auto_verified_attributes,
            "SmsVerificationMessage": sms_verification_message,
            "EmailVerificationMessage": email_verification_message,
            "EmailVerificationSubject": email_verification_subject,
            "VerificationMessageTemplate": verification_message_template,
            "SmsAuthenticationMessage": sms_authentication_message,
            "MfaConfiguration": mfa_configuration,
            "DeviceConfiguration": device_configuration,
            "EmailConfiguration": email_configuration,
            "SmsConfiguration": sms_configuration,
            "UserPoolTags": user_pool_tags,
            "AdminCreateUserConfig": admin_create_user_config,
            "UserPoolAddOns": user_pool_add_ons,
            "AccountRecoverySetting": account_recovery_setting,
        },
    )
